﻿using System;
using System.Collections.Generic;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.OnDemand
{
    /// <summary>
    /// Validate XML step.
    /// </summary>
    public class ValidateXmlStep : FilterBase<VmrOnDemandCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VmrOnDemandCreateStateObject state)
        {
            try
            {
                PipelineUtilities.ValidateSchema("Virtual Meeting Room",
                    state.SchemaPath,
                    new List<string> { "http://va.gov/vyopta/schemas/exchange/VirtualMeetingRoom/1.0" },
                    new List<string> { "VirtualMeetingRoom.xsd" },
                    state.SerializedVirtualMeetingRoom);
            }
            catch (Exception ex)
            {
                var exceptionMessage = ex.Message;
                exceptionMessage += PipelineUtilities.BuildErrorMessage(ex);
                
                state.ExceptionOccured = true;
                state.ExceptionMessage = exceptionMessage;
            }
        }
    }
}